<?php

namespace App\Http\Livewire;

use App\Models\Media;
use App\Models\MediaTranslation;
use Livewire\Component;
use Livewire\WithFileUploads;

class AdminMediaTranslationPage extends Component
{
    use WithFileUploads;

    public $media_id;
    public $translations;
    public $translationSection;
    public $media;

    //For properties
    public $language;
    public $media_file;

    public function mount($media_id){
        $this->media = Media::find($media_id);
    }

    public function showTranslations(){
        $this->translations = MediaTranslation::where('media_id', $this->media_id)->get();
        $this->translationSection = true;
        return $this->emit('alert', ['type' => 'success', 'message' => 'Translations retrieved!']);
    }

    public function hideTranslations()
    {
        $this->translationSection = false;
        return $this->emit('alert', ['type' => 'success', 'message' => 'Translations hidden!']);
    }

    public function updated($field){
        $this->validateOnly($field, [
           'language' => 'required|max:255',
            'media_file' => 'required|file|mimes:pdf,mp4,mp3|max:204800'
        ]);
    }

    public function uploadTranslation(){
        $this->validate([
            'language' => 'required|max:255',
            'media_file' => 'required|file|mimes:pdf,mp4,mp3|max:204800'
        ]);

        //Check if translation Exist
        if(MediaTranslation::where([
            ['media_id', '=', $this->media_id],
            ['language', '=', $this->language]
        ])->first()){
            $this->alert('info', 'Media translation exist', 'Press ok to verify from list');
            return $this->showTranslations();
        }

        $f_extension = $this->media_file->extension();
        //$this->storeFile($request->media_file, $file_name);
        $path = $this->media_file->store('', ['disk' => 'public_uploads']); // returns the filename

        // Insert the default English translation
        MediaTranslation::create([
            'media_id' => $this->media_id,
            'language' => $this->language,
            'type'     => $f_extension,
            'path'     => $path
        ]);

        $this->language = '';
        $this->media_file = '';

        $this->showTranslations();
        $this->alert('success', 'Media translation uploaded successfully', 'You will be redirected the translations page');
    }

    public function alert($type, $title, $text="Press Ok to Continue"){
        $this->dispatchBrowserEvent('swal:modal', [
            'type' => $type,
            'title' => $title,
            'text' => $text
        ]);
    }

    public function render()
    {
        return view('livewire.admin.pages.admin-media-translation-page');
    }
}
