<?php

namespace App\Http\Livewire;

use App\Models\Media;
use App\Models\User;
use Livewire\Component;

class AdminViewMediaPage extends Component
{

    public $media;
    public $churches;

    public $distLinks;

    public function mount($media_id){
        $this->media = Media::find($media_id);
    }

    public function showDistLinks(){
        $this->fetchChurches();
        $this->distLinks = true;
        return $this->emit('alert', ['type' => 'success', 'message' => 'Distributors Link Generated']);
    }

    public function hideDistLinks(){
        $this->distLinks = false;
        return $this->emit('alert', ['type' => 'success', 'message' => 'Distributors Link Hidden.']);
    }

    public function fetchChurches()
    {
        $this->churches = User::all();
    }



    public function confirmRequest($type, $title, $text="Press Ok to Continue", $id=''){
        $this->dispatchBrowserEvent('swal:confirm', [
            'type' => $type,
            'title' => $title,
            'text' => $text,
            'id'   => $id
        ]);
    }

    public function alert($type, $title, $text="Press Ok to Continue"){
        $this->dispatchBrowserEvent('swal:modal', [
            'type' => $type,
            'title' => $title,
            'text' => $text
        ]);
    }

    public function render()
    {
        return view('livewire.admin.pages.admin-view-media-page');
    }
}
