<?php


use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\AdminRouteController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Church Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register church web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/login', [AdminAuthController::class, 'adminLoginPage'])->name('login');
    Route::get('/reset', [AdminAuthController::class, 'adminPassword'])->name('reset');
    Route::group(['middleware' => 'auth:admin'], function () {
        Route::get('/logout',                      [AdminAuthController::class, 'logout'])->name('logout');
        Route::get('/dashboard',                   [AdminRouteController::class, 'adminDashboardPage'])->name('dashboard');
        Route::get('/all-media',                   [AdminRouteController::class, 'adminAllMediaPage'])->name('all-media');
        Route::get('/media/{media_id}',            [AdminRouteController::class, 'adminViewMediaPage'])->name('media-view');
        Route::get('/translation/{media_id}',      [AdminRouteController::class, 'adminMediaTranslationsPage'])->name('media-translation');
    });


});



