<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <title>Admin portal</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('church/plugins/fontawesome-free/css/all.min.css')); ?>">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?php echo e(asset('church/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('church/dist/css/adminlte.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('church/dist/css/toastr.css')); ?>">
    <!--Laravel livewire styles  -->
    <?php echo \Livewire\Livewire::styles(); ?>

    <style>
        .footer{
            max-height: 10vh;
            width: 100%;
            position: fixed;
            top: auto;
            bottom: 0;
            display: inline-block;
        }
        .img {
            margin: 10px;
        }
    </style>
</head>


<body class="hold-transition login-page">

<div>
    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin-login-page')->html();
} elseif ($_instance->childHasBeenRendered('NcJSV09')) {
    $componentId = $_instance->getRenderedChildComponentId('NcJSV09');
    $componentTag = $_instance->getRenderedChildComponentTagName('NcJSV09');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('NcJSV09');
} else {
    $response = \Livewire\Livewire::mount('admin-login-page');
    $html = $response->html();
    $_instance->logRenderedChild('NcJSV09', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
</div>

<footer class='footer'>
    <p class='text-center py-2' style="color: black; font-size: 1rem; ">
        Copyright &copy; Loveworld Publishing Limited
    </p>
</footer>

<!-- jQuery -->
<!--Livewire script-->
<?php echo \Livewire\Livewire::scripts(); ?>


<script src="<?php echo e(asset('church/plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('church/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('church/dist/js/adminlte.min.js')); ?>"></script>

<script  src="<?php echo e(asset('church/dist/js/toastr.js')); ?>"></script>
<script>
    window.livewire.on('alert', param => {
        toastr[param['type']](param['message'], param['type']);
    });
</script>
</body>
</html>
<?php /**PATH C:\Users\Adurotimi Stephen\Documents\PENCILEDGE\Projects\now-that-you-are-born-again\resources\views/admin/admin_login.blade.php ENDPATH**/ ?>