<div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Media Translations</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.all-media')); ?>">Media</a></li>
                        <li class="breadcrumb-item active"><?php echo e($media->name); ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">


            <div class="row">
                <div class="col-md-6">

                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo e($media->name); ?></h3>
                        </div>
                        <div class="card-body">

                            <form wire:submit.prevent="uploadTranslation">

                            <div class="form-group">
                                <p><?php echo e(strtoupper($media->type)); ?> Document Type Preferred.</p>
                                <div class="input-group" id="reservationdate" data-target-input="nearest">
                                   <select wire:model.lazy="language" class="form-control <?php echo e($errors->has('language')? 'is-invalid' : ''); ?>">
                                       <option value="">Select Language</option>
                                       <option value="English">English</option>
                                       <option value="Arabic">Arabic</option>
                                       <option value="French">French</option>
                                   </select>
                                    <div class="input-group-append">
                                        <div class="input-group-text"><i class="fa fa-language"></i></div>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span style="color: crimson; font-size: 10px;"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <div class="input-group" id="reservationdate" data-target-input="nearest">
                                    <input type="file" id="media" wire:model.lazy="media_file" class="form-control <?php echo e($errors->has('media_file')? 'is-invalid' : ''); ?>">
                                    <div class="input-group-append">
                                        <div class="input-group-text"><i class="fa fa-file"></i></div>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['media_file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span style="color: crimson; font-size: 10px;"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group">
                                <button type="submit" wire:loading.remove wire:target="media_file" class="btn btn-outline-success">
                                    <span wire:loading.remove wire:target="uploadTranslation">Upload Translation</span>
                                    <span wire:loading wire:target="uploadTranslation" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                </button>
                                <button wire:loading wire:target="media_file"  type="button" disabled class="btn btn-outline-success"> Optimizing media
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                </button>
                                <button type="button" wire:click="showTranslations" class="btn btn-outline-primary float-right">
                                    <span wire:loading.remove wire:target="showTranslations">Show Translation</span>
                                    <span wire:loading wire:target="showTranslations" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                </button>
                            </div>
                            <!-- /.form group -->
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->


                </div>
                <!-- /.col (left) -->


                
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Available media translations</h3>
                        </div>
                        <div class="card-body">
                            <!-- Date -->
                          <?php if($translationSection): ?>
                                <?php if($translations): ?>
                                    <div class="form-group">
                                        <?php $__currentLoopData = $translations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p><?php echo e($loop->index +1); ?>.)  <?php echo e($trans->name); ?> <?php echo e($trans->language); ?>

                                            </p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="form-group">
                                        <p class="text text-danger">No translation found </p>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <button type="button" wire:click="hideTranslations" class="btn btn-outline-danger"><span wire:loading.remove wire:target="hideTranslations">Hide Links</span> <span wire:loading wire:target="hideTranslations" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span></button>
                                </div>
                          <?php endif; ?>
                        </div>
                        <div class="card-footer">
                            Visit <a target="_blank" href="https://loveworldbooks.com">Loveworld Books </a> for more information about
                            the Media books and the translations.
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col (right) -->

            </div>
            <!-- /.row -->

        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
<?php /**PATH C:\Users\Adurotimi Stephen\Documents\PENCILEDGE\Projects\now-that-you-are-born-again\resources\views/livewire/admin/pages/admin-media-translation-page.blade.php ENDPATH**/ ?>